﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MieszanieKolorow;

public class Game1 : Game
{
    private GraphicsDeviceManager _graphics;
    private SpriteBatch _spriteBatch;

    public Game1()
    {
        _graphics = new GraphicsDeviceManager(this);
        Content.RootDirectory = "Content";
        IsMouseVisible = true;
    }

    BasicEffect efekt;
    VertexBuffer buforWerteksów;

    protected override void Initialize()
    {
                    efekt = new BasicEffect(this.GraphicsDevice);
            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(
            	MathHelper.PiOver2,
            	this.GraphicsDevice.Viewport.AspectRatio,
            	1,
            	10);
            efekt.View = Matrix.CreateLookAt(
            	new Vector3(0, 0, 2.5f),
            	Vector3.Zero,
            Vector3.Up);
            efekt.World = Matrix.Identity;
            efekt.VertexColorEnabled = true;
            //konfiguracja wyświetlania
            GraphicsDevice.RasterizerState = RasterizerState.CullNone;
            //aktorzy
            //Color kolor1 = Color.Red;
            //Color kolor2 = Color.White;
            Color kolor1 = new Color(Color.Red, 128);
            Color kolor2 = new Color(Color.White, 128);
            float z0 = 0.1f;
            VertexPositionColor[] tablicaWerteksów = new
            	VertexPositionColor[]
            {
            	//trójkąt biały
           	 new VertexPositionColor(new Vector3(1,-1,-z0), kolor1),
           	 new VertexPositionColor(new Vector3(-1,-1,-z0), kolor1),
           	 new VertexPositionColor(new Vector3(0,1,-z0), kolor1),
            	//trójkąt czerwony
           	 new VertexPositionColor(new Vector3(1,-1,z0), kolor2),
            	 new VertexPositionColor(new Vector3(-1,-1,z0), kolor2),
           	 new VertexPositionColor(new Vector3(0,1,z0), kolor2)
            };
            buforWerteksów = new VertexBuffer(
            	GraphicsDevice,
            	VertexPositionColor.VertexDeclaration,
           	6,
            BufferUsage.WriteOnly);
            buforWerteksów.SetData(tablicaWerteksów);

        BlendState bs = new BlendState();
        bs.ColorSourceBlend = Blend.SourceAlpha;
        bs.AlphaSourceBlend = Blend.SourceAlpha;
        bs.ColorDestinationBlend = Blend.InverseSourceAlpha;
        bs.AlphaDestinationBlend = Blend.InverseSourceAlpha;
        bs.AlphaBlendFunction = BlendFunction.Add;
        GraphicsDevice.BlendState = bs;

        GraphicsDevice.BlendState = BlendState.NonPremultiplied;

        //DepthStencilState dss = new DepthStencilState();
        //dss.DepthBufferEnable = false;
        //GraphicsDevice.DepthStencilState = dss;

        base.Initialize();
    }

    protected override void LoadContent()
    {
        _spriteBatch = new SpriteBatch(GraphicsDevice);

        // TODO: use this.Content to load your game content here
    }

    float kąt = 0;

    protected override void Update(GameTime gameTime)
    {
        if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
            Exit();

        /*
        efekt.World *=
            Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
        */
        kąt += gameTime.ElapsedGameTime.Milliseconds / 1000.0f;

        if (kąt > MathHelper.TwoPi) kąt = 0;
        efekt.World = Matrix.CreateRotationY(kąt);

        base.Update(gameTime);
    }

    protected override void Draw(GameTime gameTime)
    {
        GraphicsDevice.Clear(Color.Black);
        GraphicsDevice.SetVertexBuffer(buforWerteksów);

    bool czerwonyPierwszy =
        (kąt > 0 && kąt < MathHelper.PiOver2) ||
        (kąt > 3 * MathHelper.PiOver2 && kąt < MathHelper.TwoPi);

        foreach (EffectPass p in efekt.CurrentTechnique.Passes)
        {
            p.Apply();
            /*
            GraphicsDevice.DrawPrimitives(
                PrimitiveType.TriangleList,
                0,
                2);
            */
            if (czerwonyPierwszy)
            {
                GraphicsDevice.DrawPrimitives(PrimitiveType.TriangleList,0,2);
            }
            else
            {
                GraphicsDevice.DrawPrimitives(PrimitiveType.TriangleList,3,1);
                GraphicsDevice.DrawPrimitives(PrimitiveType.TriangleList,0,1);
            }
        }

        base.Draw(gameTime);
    }
}
